/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function copies a DFile record from its buffer into sorting memory.
*/
int copy_sort_record( field_t **rec, dfile_bind_t *bind, unsigned short bind_cnt, unsigned short *io_field_map, unsigned short io_field_map_cnt )
{
	size_t	record_size, field_length;
	unsigned short	ndx, field_ndx;
	char	*new_buffer, *ptr;
	field_t	*field, *field_vector;

	assert( rec != (field_t **)0 );
	assert( bind != (dfile_bind_t *)0 );
	assert( bind_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	/*
	** Calculate record size.
	*/
	record_size = (size_t)0;

	for ( ndx = (unsigned short)0; ndx < io_field_map_cnt; ++ndx ) {
		field_ndx = io_field_map[ ndx ];

		if ( field_ndx != USHRT_MAX ) {
			record_size += *bind[ field_ndx ].field_length;
		}

		/*
		** Add space for null.
		*/
		++record_size;
	}


	new_buffer = (char *)malloc( record_size );
	if ( new_buffer == (char *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	field_vector = (field_t *)malloc( (size_t)io_field_map_cnt * sizeof( field_t ) );
	if ( field_vector == (field_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	ptr = new_buffer;
	field = field_vector;
	for ( ndx = (unsigned short)0; ndx < io_field_map_cnt; ++ndx ) {
		field_ndx = io_field_map[ ndx ];
		if ( field_ndx == USHRT_MAX ) {
			field_length = (size_t)0;
		} else {
			field_length = *bind[ field_ndx ].field_length;
		}
		if ( field_length > (size_t)0 ) {
			(void) memcpy( (void *)ptr, (void *)*bind[ field_ndx ].field_buffer, field_length );
		}
		ptr[ field_length ] = (char)0;
		field->value = ptr;
		field->length = field_length;
		ptr += field_length + (size_t)1;
		++field;
	}

	*rec = field_vector;

	RETURN_INT( 0 );
}
