/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function assigns information from control structure.
*/
int assign_output( output_t *output, sexpr_t *dfile, unsigned short tuple_cnt )
{
	char	*section;
	int	ret;
	sexpr_t	*dfile_attribute;

	assert( output != (output_t *)0 );

	DEBUG_FUNC_START;

	if ( dfile == (sexpr_t *)0 || SEXPR_CAR_TYPE( dfile ) != list_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a list", tuple_cnt );
		RETURN_INT( -1 );
	}

	dfile_attribute = SEXPR_CAR_LIST( dfile );

	if ( SEXPR_CAR_TYPE( dfile_attribute ) != string_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	section = SEXPR_CAR_STRING( dfile_attribute );

	if ( Debug ) {
		(void) fprintf( stderr, "section [%s]\n", section );
	}

	assert( SEXPR_CDR_TYPE( dfile_attribute ) == list_sexpr );

	dfile_attribute = SEXPR_CDR_LIST( dfile_attribute );

	if ( dfile_attribute == (sexpr_t *)0 || SEXPR_CAR_TYPE( dfile_attribute ) != string_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "attribute [%s]\n", SEXPR_CAR_STRING( dfile_attribute ) );
	}

	if ( strcasecmp( section, "dfile" ) != 0 ) {
		CONTROL_SYNTAX_ERROR( "expected dfile literal", tuple_cnt );
		RETURN_INT( -1 );
	}

	output->dfile_name = SEXPR_CAR_STRING( dfile_attribute );

	if ( Debug ) {
		fprintf( stderr, "found dfile [%s]\n", output->dfile_name );
	}

	assert( SEXPR_CDR_TYPE( dfile_attribute ) == list_sexpr );

	ret = assign_output_dfile( output, SEXPR_CDR_LIST( dfile_attribute ), tuple_cnt );

	RETURN_INT( ret );
}
