/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"
#include "dfile_partition.h"


/*
** This function maps input bind to output bind.
*/
int map_bind( dfile_bind_t **output_sorted_bind, unsigned short output_bind_cnt, dfile_bind_t **input_sorted_bind, unsigned short input_bind_cnt )
{
	int	cmp;
	dfile_bind_t	*ibind, *obind;

	assert( output_sorted_bind != (dfile_bind_t **)0 );
	assert( input_sorted_bind != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

#if 0
	if ( _dfile_alloc_bind_fields( output_bind, output_bind_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}
#endif

	while ( input_bind_cnt > (unsigned short)0 && output_bind_cnt > (unsigned short)0 ) {
		cmp = dfile_bind_field_name_cmp( input_sorted_bind, output_sorted_bind );

		if ( cmp > 0 ) {
			++output_sorted_bind;
			--output_bind_cnt;
			continue;
		}

		if ( cmp < 0 ) {
			++input_sorted_bind;
			--input_bind_cnt;
			continue;
		}

		ibind = *input_sorted_bind;
		obind = *output_sorted_bind;

		obind->field_buffer = ibind->field_buffer;
		obind->field_length = ibind->field_length;

		++output_sorted_bind;
		--output_bind_cnt;

		++input_sorted_bind;
		--input_bind_cnt;
	}

	RETURN_INT( 0 );
}
