/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_partition.h"


/*
** This function load a range partition definition file in to memory.
*/
int load_range_partition_file( char ***divvy_text, unsigned short *divvy_text_cnt, const char *divvy_fname )
{
	unsigned long	divvy_text_cnt_tmp;

	assert( divvy_text != (char ***)0 );
	assert( divvy_text_cnt != (unsigned short *)0 );
	assert( divvy_fname != (const char *)0 );

	DEBUG_FUNC_START;

	*divvy_text_cnt = (unsigned short)0;
	*divvy_text = (char **)0;

	divvy_text_cnt_tmp = 0UL;

	if ( load_text_file( divvy_text, &divvy_text_cnt_tmp, divvy_fname ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( divvy_text_cnt_tmp > (unsigned long)USHRT_MAX ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "number of partitions (", stderr );
		(void) fput_ulong( divvy_text_cnt_tmp, stderr );
		(void) fputs( ") exceeded maximum (", stderr );
		(void) fput_ulong( (unsigned long)USHRT_MAX, stderr );
		(void) fputs( ").\n", stderr );

		RETURN_INT( -1 );
	}

	*divvy_text_cnt = (unsigned short)divvy_text_cnt_tmp;

	if ( *divvy_text_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Partition definition file was empty.\n", stderr );
		RETURN_INT( -1 );
	}

	if ( *divvy_text_cnt > (unsigned short)50 ) {
		shell_sort( (void *)*divvy_text, (size_t)*divvy_text_cnt, sizeof( char * ), divvy_cmp );
	} else {
		insertion_sort( (void *)*divvy_text, (size_t)*divvy_text_cnt, sizeof( char * ), divvy_cmp );
	}

	RETURN_INT( 0 );
}
