/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


static int cmp_func( const void *, const void * );
static unsigned short	key_field_cnt;

/*
** This function retrieves a set of records from shared memory that join
** to current input record.
*/
void get_shm_join_records( shm_t *shm, unsigned long *record_cnt, dfile_bind_t **bind, unsigned short key_ndx_tbl_cnt )
{
	char	***match, **input_key_tbl;
	unsigned long	rec_cnt;
	unsigned short	ndx;

	assert( shm != (shm_t *)0 );
	assert( bind != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	input_key_tbl = shm->input_key_tbl;

	for ( ndx = (unsigned short)0; ndx < key_ndx_tbl_cnt; ++ndx ) {
		input_key_tbl[ ndx ] = *( *bind )->field_buffer;
		++bind;
	}

	key_field_cnt = key_ndx_tbl_cnt;

	match = (char ***)nubsearch( (void *)&input_key_tbl, (void *)shm->key, shm->rec_cnt, sizeof( const char ** ), cmp_func );

	if ( match == (char ***)0 ) {
		/*
		** No match found.
		*/
		shm->matched_record_offset = 0UL;
		*record_cnt = 0UL;
		RETURN_VOID;
	}

	assert( match >= shm->key );
	shm->matched_record_offset = (unsigned long)( match - shm->key );

	rec_cnt = 0UL;

	while ( match != (char ***)0 ) {
		++rec_cnt;
		match = (char ***)nubsearch_next( (void *)match, (void *)shm->key, shm->rec_cnt, sizeof( const char ** ), cmp_func );
	}

	*record_cnt = rec_cnt;

	if ( Debug ) {
		(void) fprintf( stderr, "%lu records matched\n", *record_cnt );
	}

	RETURN_VOID;
}

static int cmp_func( const void *x, const void *y )
{
	int	result;
	unsigned short	ndx;
	const char	**lhs, **rhs;

	lhs = *(const char ***)x;
	rhs = *(const char ***)y;

	for ( ndx = (unsigned short)0; ndx < key_field_cnt; ++ndx ) {
		result = strcmp( *lhs, *rhs );

		if ( result != 0 ) {
			return result;
		}

		++lhs;
		++rhs;
	}

	return 0;
}
