/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function creates bind array for shared memory data access.
*/
int create_shm_bind( dfile_bind_t **bind, unsigned short *bind_cnt, dfile_bind_t ***sorted_bind, const char *dfile_name )
{
	dfile_cfg_t	cfg;
	size_t	alloc_size;
	dfile_bind_t	*new_bind, **new_sorted_bind;
	unsigned short	ndx;

	assert( bind != (dfile_bind_t **)0 );
	assert( bind_cnt != (unsigned short *)0 );
	assert( sorted_bind != (dfile_bind_t ***)0 );
	assert( dfile_name != (const char *)0 );

	DEBUG_FUNC_START;

	*bind = (dfile_bind_t *)0;
	*bind_cnt = (unsigned short)0;
	*sorted_bind = (dfile_bind_t **)0;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	alloc_size = sizeof( dfile_bind_t ) * (size_t)cfg.field_name_cnt;
	new_bind = (dfile_bind_t *)malloc( alloc_size );

	if ( new_bind == (dfile_bind_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	if ( _dfile_alloc_bind_fields( new_bind, cfg.field_name_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	alloc_size = sizeof( dfile_bind_t * ) * (size_t)cfg.field_name_cnt;
	new_sorted_bind = (dfile_bind_t **)malloc( alloc_size );

	if ( new_sorted_bind == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	*sorted_bind = new_sorted_bind;
	*bind = new_bind;
	*bind_cnt = cfg.field_name_cnt;

	for ( ndx = (unsigned short)0; ndx < cfg.field_name_cnt; ++ndx ) {
		new_bind->field_name = cfg.field_name[ ndx ];
		new_sorted_bind[ ndx ] = new_bind;
		++new_bind;
	}

	if ( insertion_sort( (void *)new_sorted_bind, (size_t)cfg.field_name_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp ) == -1 ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
