/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int assign_outer_join( char **status_field, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	char	*str;
	sexpr_t	*oj_sexpr;

	assert( status_field != (char **)0 );

	DEBUG_FUNC_START;

	while ( sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( sexpr ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		oj_sexpr = SEXPR_CAR_LIST( sexpr );

		if ( oj_sexpr == (sexpr_t *)0 ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		if ( SEXPR_CAR_TYPE( oj_sexpr ) != string_sexpr ) {
			control_syntax_error( "expected a string", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		str = SEXPR_CAR_STRING( oj_sexpr );

		if ( Debug ) {
			fprintf( stderr, "str = [%s]\n", str );
		}

		assert( SEXPR_CDR_TYPE( oj_sexpr ) == list_sexpr );

		if ( strcasecmp( str, "status-field" ) == 0 ) {
			oj_sexpr = SEXPR_CDR_LIST( oj_sexpr );

			if ( oj_sexpr == (sexpr_t *)0 || SEXPR_CAR_TYPE( oj_sexpr ) != string_sexpr ) {
				control_syntax_error( "expected status field name", __FILE__, __LINE__, tuple_cnt );
				RETURN_INT( -1 );
			}

			str = SEXPR_CAR_STRING( oj_sexpr );

			if ( Debug ) {
				fprintf( stderr, "str = [%s]\n", str );
			}

			*status_field = str;

			assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );
			sexpr = SEXPR_CDR_LIST( sexpr );

			continue;
		}

		control_syntax_error( "syntax error", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
