/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function assigns information from control structure.
*/
int assign_step( step_t **step, unsigned short *step_cnt, sexpr_t *field, unsigned short tuple_cnt )
{
	char	*str;
	int	ret;
	step_t	*new;
	size_t	alloc_size;

	assert( step != (step_t **)0 );
	assert( step_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	if ( field == (sexpr_t *)0 ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	if ( SEXPR_CAR_TYPE( field ) != string_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	str = SEXPR_CAR_STRING( field );

	assert( SEXPR_CDR_TYPE( field ) == list_sexpr );

	if ( SEXPR_CDR_LIST( field ) == (sexpr_t *)0 ) {
		CONTROL_SYNTAX_ERROR( "null list", tuple_cnt );
		RETURN_INT( -1 );
	}


	if ( strcasecmp( str, "step" ) == 0 ) {
		alloc_size = ( *step_cnt + (unsigned short)1 ) * sizeof( step_t );
		new = (step_t *)realloc( *step, alloc_size );
		if ( new == (step_t *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		ret = assign_step_attrib( &new[ *step_cnt ], SEXPR_CDR_LIST( field ), tuple_cnt );

		if ( ret == 0 ) {
			*step = new;
			++*step_cnt;
		}

		RETURN_INT( ret );
	}


	CONTROL_SYNTAX_ERROR( "unknown section", tuple_cnt );

	RETURN_INT( -1 );
}
