/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function allocates proc table array. Its size corresponds to
** number of slices to be processed.
*/
proc_t *alloc_proc_tbl( unsigned short cnt )
{
	size_t	alloc_size;
	proc_t	*proc_tbl;

	DEBUG_FUNC_START;

	alloc_size = sizeof( proc_t ) * (size_t)cnt;
	proc_tbl = (proc_t *)malloc( alloc_size );
	if ( proc_tbl == (proc_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (proc_t *)0 );
	}

	(void) memset( (void *)proc_tbl, 0, alloc_size );

	RETURN_POINTER( proc_tbl );
}
