/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This function reads a file containing a filter expression and loads
** it into an s-expression tree. The next stage it processes the s-expression
** tree into a syntax tree and performs semantic checks. The structure
** returned from this function is ready for interpreter to process.
*/

int where_compile_file( void **ret_condition, char *err_msg, size_t err_msg_size, const char *file_name, dfile_t *dfile )
{
	int	ret;
	sexpr_t	*sexpr;

	assert( ret_condition != (void **)0 );
	assert( file_name != (char *)0 );
	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fputs( "compiling file [", stderr );
		(void) fputs( file_name, stderr );
		(void) fputs( "]\n", stderr );
	}

	ret = sexpr_load( &sexpr, file_name );
	if ( ret != SEXPR_NOERR ) {
		if ( err_msg != (char *)0 && err_msg_size > (size_t)0 ) {
			--err_msg_size;
			(void) strncpy( err_msg, sexpr_error( ret ), err_msg_size );
			err_msg[ err_msg_size ] = (char)0;
		}
		RETURN_INT( WHERE_SYNTAX );
	}

	ret = _where_build_syntax_tree( (condition_t **)ret_condition, sexpr, dfile );

	if ( ret != WHERE_NOERR ) {
		if ( err_msg != (char *)0 && err_msg_size > (size_t)0 ) {
			--err_msg_size;
			(void) strncpy( err_msg, where_error( ret ), err_msg_size );
			err_msg[ err_msg_size ] = (char)0;
		}
	}

	RETURN_INT( ret );
}
