/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <regex.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This function executes the regex match for LIKE operator as part of the
** interpreter.
*/

int _where_like_condition( where_result_t *result, like_cond_t *like_cond )
{
	int	status;
	char	msg[256];

	assert( result != (where_result_t *)0 );
	assert( like_cond != (like_cond_t *)0 );

	DEBUG_FUNC_START;

	status = regexec( (regex_t *)like_cond->regex, *like_cond->dfile_bind->field_buffer, (size_t)0, (regmatch_t *)0, 0 );

	switch ( status ) {
	case 0:
		*result = Where_result_true;
		break;
	case REG_NOMATCH:
		*result = Where_result_false;
		break;
	default:
		fput_src_code( __FILE__, __LINE__, stderr );
		(void) fputs( "regexec() failed [", stderr );
		(void) regerror( status, (regex_t *)like_cond->regex, msg, sizeof( msg ) );
		(void) fputs( msg, stderr );
		(void) fputs( "]\n", stderr );
		RETURN_INT( WHERE_REGEX );
	}

	if ( Debug ) {
		if ( *result == Where_result_false ) {
			(void) fputs( "result is false\n", stderr );
		} else {
			(void) fputs( "result is true\n", stderr );
		}
	}

	RETURN_INT( WHERE_NOERR );
}
