/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"


int _sexpr_parse_pair( sexpr_t **sexpr, int *ret_end_of_list_flag, const char **str, unsigned long depth )
{
	sexpr_t	*new, *prev;
	int	ret;
	sexpr_value_t	car;

	assert( sexpr != (sexpr_t **)0 );
	assert( ret_end_of_list_flag != (int *)0 );
	assert( str != (const char **)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "depth is %lu\n", depth );
	}

	*sexpr = (sexpr_t *)0;
	prev = (sexpr_t *)0;

	for ( ;; ) {

		ret = _sexpr_assign_car( &car, ret_end_of_list_flag, str, depth );
		if ( ret != 0 || *ret_end_of_list_flag ) {
			break;
		}

		if ( **str == (char)0 ) {
			/*
			** Failed to find closing parenthesis.
			*/
			ret = SEXPR_RPAREN;
			break;
		}

		new = (sexpr_t *)malloc( sizeof( sexpr_t ) );

		if ( new == (sexpr_t *)0 ) {
			UNIX_ERROR( "malloc() failed" );
			ret = -1;
			break;
		}

		new->car = car;
		SEXPR_CDR_TYPE( new ) = list_sexpr;
		SEXPR_CDR_LIST( new ) = (sexpr_t *)0;

		if ( prev == (sexpr_t *)0 ) {
			/*
			** Should only be true during first iteration
			** of loop.
			*/
			*sexpr = new;
		} else {
			SEXPR_CDR_LIST( prev ) = new;
		}

		prev = new;
	}

	RETURN_INT( ret );
}
