/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function copies beginning portion of record that was found at end
** of buffer to an overflow area. It also changes the bind variables to
** point to overflow area.
*/
int _dfile_var_record_save_overflow( dfile_t *dfile, char *buf_ptr, dfile_buffer_t *buffer, char *next_field, unsigned short processed_field_cnt, unsigned short bind_processed_cnt )
{
	char	*overflow, *start_of_record, *buf_ptr_end;
	size_t	overflow_length, needed_overflow_size, field_offset;
	dfile_bind_t	*bind;

	assert( dfile != (dfile_t *)0 );
	assert( buf_ptr != (char *)0 );
	assert( buffer != (dfile_buffer_t *)0 );
	assert( next_field != (char *)0 );

	DEBUG_FUNC_START;

	overflow = dfile->overflow;

	start_of_record = dfile->read_var_rec.start_of_record;
	assert( start_of_record != (char *)0 );

	buf_ptr_end = buffer->buf_ptr_end;
	assert( buf_ptr_end >= start_of_record );

	overflow_length = (size_t)( buf_ptr_end - start_of_record );

	assert( next_field >= start_of_record );

	needed_overflow_size = (size_t)( next_field - start_of_record ) + (size_t)1;

	if ( needed_overflow_size > dfile->overflow_size ) {
		overflow = (char *)realloc( overflow, needed_overflow_size );
		if ( overflow == (char *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}
		dfile->overflow = overflow;
		dfile->overflow_size = needed_overflow_size;
	}

	(void) memcpy( (void *)overflow, (void *)start_of_record, overflow_length );

	bind = dfile->bind;
	assert( bind != (dfile_bind_t *)0 );

	for ( ; bind_processed_cnt > (unsigned short)0; --bind_processed_cnt ) {
		assert( *bind->field_buffer >= start_of_record );
		field_offset = (size_t)( *bind->field_buffer - start_of_record );
		*bind->field_buffer = &overflow[ field_offset ];
		++bind;
	}

	dfile->overflow_length = overflow_length;
	buffer->buf_ptr = buf_ptr_end;

	dfile->read_var_rec.processed_field_cnt = processed_field_cnt;
	dfile->read_var_rec.current_bind = bind;

	dfile->read_var_rec.append_overflow_len = (size_t)( next_field - buf_ptr_end );

	RETURN_INT( 0 );
}
