/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function parses fields in a character delimited record.
*/

dfile_parse_t _dfile_parse_record( dfile_t *dfile )
{
	dfile_bind_t	*bind;
	unsigned short	parse_field_ndx;
	dfile_parse_t	ret, parse;
	dfile_buffer_t	*buffer;
	size_t	*field_length, tmp_len;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	bind = dfile->bind;
	parse_field_ndx = (unsigned short)0;
	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );

	assert( bind != (dfile_bind_t *)0 );
	assert( dfile->parse_func != (dfile_parse_t (*)( char **, size_t *, dfile_rec_t ) )0 );

	while ( dfile->bind_cnt > parse_field_ndx ) {
		if ( bind->field_length == (size_t *)0 ) {
			field_length = &tmp_len;
		} else {
			field_length = bind->field_length;
		}
		*bind->field_buffer = buffer->buf_ptr;
		++bind;

		parse = ( *dfile->parse_func )( &buffer->buf_ptr, field_length, dfile->rec_attribute );

		++parse_field_ndx;

		if ( parse != Dfile_parsed_field ) {
			break;
		}
	}

	while ( parse == Dfile_parsed_field ) {
		/*
		** Record contained more fields than expected.
		** Process and discard extract fields.
		*/
		parse = ( *dfile->parse_func )( &buffer->buf_ptr, field_length, dfile->rec_attribute );

		++parse_field_ndx;
	}

	assert( buffer->buf_ptr <= buffer->buf_ptr_end );

	if ( parse_field_ndx != dfile->bind_cnt ) {
		++dfile->parse_fail_rec_cnt;
		ret = Dfile_parse_failed;
		if ( dfile->record_failure_func != (int (*)( dfile_t *, unsigned short ) )0 ) {
			if ( dfile->record_failure_func( dfile, parse_field_ndx ) == -1 ) {
				ret = Dfile_fatal_parse_error;
			}
		}

		if ( Debug ) {
			(void) fputs( "parse failed\n", stderr );
		}

		RETURN_INT( ret );
	}

	if ( Debug ) {
		(void) fputs( "parsed record\n", stderr );
	}

	RETURN_INT( Dfile_parsed_record );
}
