/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function allocates the dfile_buffer_t structures. Although, actual
** memory used to contain buffer data is allocated later. These structures
** allocated during the dfile_read_open() and dfile_write_open() calls.
*/

dfile_buffer_t *_dfile_create_buffers( unsigned short buffer_cnt, const dfile_state_t *state_tbl )
{
	dfile_buffer_t	*new, *ptr;
	size_t	alloc_size;
	unsigned short	ndx;

	assert( buffer_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	alloc_size = sizeof( dfile_buffer_t ) * (size_t)buffer_cnt;
	new = (dfile_buffer_t *)malloc( alloc_size );
	if ( new == (dfile_buffer_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (dfile_buffer_t *)0 );
	}

	(void) memset( (void *)new, 0, alloc_size );
	ptr = new;

	for ( ndx = (unsigned short)0; ndx < buffer_cnt; ++ndx ) {
		ptr->buffer_id = ndx;
		ptr->next = &ptr[ 1 ];
		ptr->state = state_tbl;
#ifdef DFILE_THREAD
		if ( buffer_cnt > (unsigned short)1 ) {
			ptr->thread_id = (pthread_t)0;

			pthread_mutex_init( &ptr->mutex, (pthread_mutexattr_t *)0 );
		}
#endif
		++ptr;
	}

	--ptr;
	ptr->next = new;

	RETURN_POINTER( new );
}
