/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


#ifdef DFILE_THREAD
/*
** This function contains a loop for threaded output processing. It is
** called by pthread_create(). Returning from this function causes
** the thread to exit.
*/

void *_dfile_buffer_write_thread( void *x )
{
	dfile_t	*dfile;
	dfile_buffer_t	*buffer;
	int	ret;
	char	processing_complete_flag;

	assert( x != (void *)0 );

	DEBUG_FUNC_START;

	dfile = (dfile_t *)x;

	for ( ;; ) {
		buffer = dfile->io_buffer;
		assert( buffer != (dfile_buffer_t *)0 );

		if ( _dfile_buffer_wait( buffer, Dfile_io_state, dfile->buffer_cnt ) == -1 ) {
			dfile->error = Dfile_io_failed;
			RETURN_POINTER( (void *)0 );
		}

		assert( dfile->io_buffer_func != (int (*)( dfile_t * ) )0 );

		ret = ( *dfile->io_buffer_func )( dfile );

		dfile->io_buffer = dfile->io_buffer->next;

		/*
		** Need local variable processing_complete_flag to
		** prevent race condition.
		*/
		processing_complete_flag = buffer->processing_complete_flag;
		
		if ( _dfile_release_buffer( buffer ) == -1 ) {
			RETURN_POINTER( (void *)0 );
		}

		if ( ret == -1 || processing_complete_flag == 'Y' ) {
			break;
		}
	}

	RETURN_POINTER( (void *)0 );
}
#endif
