/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_unique.h"


/*
** This function assigns pointers for field keys.
*/
void assign_field_key( field_t **key_field_tbl, field_t *rec, dfile_bind_t **key_bind_tbl, unsigned short key_cnt, dfile_bind_t *input_bind_tbl )
{
	unsigned short	ndx;

	assert( key_field_tbl != (field_t **)0 );
	assert( rec != (field_t *)0 );
	assert( key_bind_tbl != (dfile_bind_t **)0 );
	assert( input_bind_tbl != (dfile_bind_t *)0 );
	assert( key_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	for ( ; key_cnt > (unsigned short)0; --key_cnt ) {
		assert( *key_bind_tbl >= input_bind_tbl );
		ndx = (unsigned short)( *key_bind_tbl - input_bind_tbl );
		*key_field_tbl = &rec[ ndx ];
		++key_field_tbl;
		++key_bind_tbl;
	}

	RETURN_VOID;
}
