/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function assigns information from control structure.
*/
int level1_syntax( order_by_t **order_by, unsigned short *order_by_cnt, sm_dfile_t **sort, unsigned short *sort_cnt, char *sort_algorithm, sm_dfile_t **merge, unsigned short *merge_cnt, output_t *output, sexpr_t *level1, unsigned short tuple_cnt )
{
	char	*str;
	int	ret;

	/*
	** processed flags initialized to false.
	*/
	static int	order_by_processed_flag = 0;
	static int	sort_processed_flag = 0;
	static int	merge_processed_flag = 0;
	static int	output_processed_flag = 0;

	assert( order_by != (order_by_t **)0 );
	assert( order_by_cnt != (unsigned short *)0 );
	assert( sort != (sm_dfile_t **)0 );
	assert( sort_cnt != (unsigned short *)0 );
	assert( sort_algorithm != (char *)0 );
	assert( merge != (sm_dfile_t **)0 );
	assert( merge_cnt != (unsigned short *)0 );
	assert( output != (output_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( level1 ) != string_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	str = SEXPR_CAR_STRING( level1 );

	assert( SEXPR_CDR_TYPE( level1 ) == list_sexpr );

	if ( SEXPR_CDR_LIST( level1 ) == (sexpr_t *)0 ) {
		CONTROL_SYNTAX_ERROR( "null list", tuple_cnt );
		RETURN_INT( -1 );
	}


	if ( strcmp( str, "order-by" ) == 0 ) {
		if ( order_by_processed_flag ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "More than one ORDER-BY configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_order_by( order_by, order_by_cnt, SEXPR_CDR_LIST( level1 ), tuple_cnt );

		/*
		** Set order_by_processed_flag to true.
		*/
		order_by_processed_flag = 1;

		RETURN_INT( ret );
	}

	if ( strcmp( str, "sort" ) == 0 ) {
		if ( sort_processed_flag ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "More than one SORT configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_sort( sort, sort_cnt, sort_algorithm, SEXPR_CDR_LIST( level1 ), tuple_cnt );

		/*
		** Set sort_processed_flag to true.
		*/
		sort_processed_flag = 1;

		RETURN_INT( ret );
	}

	if ( strcmp( str, "merge" ) == 0 ) {
		if ( merge_processed_flag ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "More than one MERGE configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_sort( merge, merge_cnt, (char *)0, SEXPR_CDR_LIST( level1 ), tuple_cnt );

		/*
		** Set merge_processed_flag to true.
		*/
		merge_processed_flag = 1;

		RETURN_INT( ret );
	}

	if ( strcmp( str, "output" ) == 0 ) {
		if ( output_processed_flag ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "More than one OUTPUT configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_output( output, SEXPR_CDR_LIST( level1 ), tuple_cnt );

		/*
		** Set output_processed_flag to true.
		*/
		output_processed_flag = 1;

		RETURN_INT( ret );
	}

	CONTROL_SYNTAX_ERROR( "unknown section", tuple_cnt );

	RETURN_INT( -1 );
}
