/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_sort.h"


/*
** This function assigns information from control structure.
*/
int assign_control_information( order_by_t **order_by, unsigned short *order_by_cnt, sm_dfile_t **sort, unsigned short *sort_cnt, char *sort_algorithm, sm_dfile_t **merge, unsigned short *merge_cnt, output_t *output, const char *control_file )
{
	int	result;
	unsigned short	tuple_cnt;
	sexpr_t	*level0;

	assert( order_by != (order_by_t **)0 );
	assert( order_by_cnt != (unsigned short *)0 );
	assert( sort != (sm_dfile_t **)0 );
	assert( sort_cnt != (unsigned short *)0 );
	assert( sort_algorithm != (char *)0 );
	assert( merge != (sm_dfile_t **)0 );
	assert( merge_cnt != (unsigned short *)0 );
	assert( output != (output_t *)0 );

	DEBUG_FUNC_START;

	*order_by = (order_by_t *)0;
	*order_by_cnt = (unsigned short)0;
	*sort = (sm_dfile_t *)0;
	*sort_cnt = (unsigned short)0;
	*merge = (sm_dfile_t *)0;
	*merge_cnt = (unsigned short)0;

	output->dfile_name = (const char *)0;
	output->tag = (dfile_tag_t *)0;
	output->tag_cnt = (unsigned short)0;
	output->blocks_per_buffer_cnt = (unsigned short)2;
	output->buffer_cnt = (unsigned short)1;
	output->dfile_open_mode = Dfile_trunc;

	if ( control_file == (const char *)0 ) {
		/*
		** no control file
		*/
		RETURN_INT( 0 );
	}

	result = sexpr_load( &level0, control_file );
	if ( result != 0 ) {
		fput_src_code( __FILE__, __LINE__, stderr );
		(void) fputs( "failed to load s-expression from file [", stderr );
		(void) fputs( control_file, stderr );
		(void) fputs( "]: [", stderr );
		(void) fputs( sexpr_error( result ), stderr );
		(void) fputs( "]\n", stderr );

		RETURN_INT( -1 );
	}

	tuple_cnt = (unsigned short)0;

	/*
	** Loop through each tuple at depth 1.
	*/
	while ( level0 != (sexpr_t *)0 ) {
		++tuple_cnt;
		if ( SEXPR_CAR_TYPE( level0 ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );

			RETURN_INT( -1 );
		}

		result = level1_syntax( order_by, order_by_cnt, sort, sort_cnt, sort_algorithm, merge, merge_cnt, output, SEXPR_CAR_LIST( level0 ), tuple_cnt );
		if ( result != 0 ) {
			RETURN_INT( result );
		}

		assert( SEXPR_CDR_TYPE( level0 ) == list_sexpr );

		level0 = SEXPR_CDR_LIST( level0 );
	}

	RETURN_INT( 0 );
}
