/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int assign_tag( dfile_tag_t **tag, unsigned short *tag_cnt, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	str_msg[] = "expected a string";
	static const char	len_msg[] = "expected tag to have two values";
	sexpr_t	*tag_sexpr;
	size_t	alloc_size;
	dfile_tag_t	*new;

	assert( tag != (dfile_tag_t **)0 );
	assert( tag_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	*tag = (dfile_tag_t *)0;
	*tag_cnt = (unsigned short)0;

	while ( sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( sexpr ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		tag_sexpr =  SEXPR_CAR_LIST( sexpr );
		if ( SEXPR_CAR_TYPE( tag_sexpr ) != string_sexpr ) {
			control_syntax_error( str_msg, __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		alloc_size = sizeof( dfile_tag_t ) * ( (size_t)*tag_cnt + (size_t)1 );
		new = (dfile_tag_t *)realloc( *tag, alloc_size );
		if ( new == (dfile_tag_t *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		*tag = new;
		new += *tag_cnt;
		++*tag_cnt;

		new->tag = SEXPR_CAR_STRING( tag_sexpr );

		assert( SEXPR_CDR_TYPE( tag_sexpr ) == list_sexpr );

		if ( SEXPR_CDR_LIST( tag_sexpr ) == (sexpr_t *)0 ) {
			control_syntax_error( len_msg, __FILE__, __LINE__, tuple_cnt );
		}

		tag_sexpr = SEXPR_CDR_LIST( tag_sexpr );

		if ( SEXPR_CAR_TYPE( tag_sexpr ) != string_sexpr ) {
			control_syntax_error( str_msg, __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		new->tag_value = SEXPR_CAR_STRING( tag_sexpr );

		assert( SEXPR_CDR_TYPE( tag_sexpr ) == list_sexpr );
		if ( SEXPR_CDR_LIST( tag_sexpr ) != (sexpr_t *)0 ) {
			control_syntax_error( len_msg, __FILE__, __LINE__, tuple_cnt );
		}

		if ( Debug ) {
			(void) fprintf( stderr, "tag: [%s] = [%s]\n", new->tag, new->tag_value );
		}

		assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

		sexpr = SEXPR_CDR_LIST( sexpr );
	}

	RETURN_INT( 0 );
}
