/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int assign_map_fields( map_field_t **map_field, unsigned short *map_field_cnt, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	len_msg[] = "expected map_field to have two values";
	int	ret;
	sexpr_t	*map_field_sexpr;
	size_t	alloc_size;
	map_field_t	*new;

	assert( map_field != (map_field_t **)0 );
	assert( map_field_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	*map_field = (map_field_t *)0;
	*map_field_cnt = (unsigned short)0;

	while ( sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( sexpr ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		map_field_sexpr = SEXPR_CAR_LIST( sexpr );

		if ( SEXPR_CAR_TYPE( map_field_sexpr ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		alloc_size = sizeof( map_field_t ) * ( (size_t)*map_field_cnt + (size_t)1 );
		new = (map_field_t *)realloc( *map_field, alloc_size );
		if ( new == (map_field_t *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		*map_field = new;
		new += *map_field_cnt;
		++*map_field_cnt;

		ret = assign_list_pair( &new->field[ 0 ].direction, &new->field[ 0 ].field_name, SEXPR_CAR_LIST( map_field_sexpr ), tuple_cnt );
		if ( ret == -1 ) {
			RETURN_INT( ret );
		}

		assert( SEXPR_CDR_TYPE( map_field_sexpr ) == list_sexpr );

		map_field_sexpr = SEXPR_CDR_LIST( map_field_sexpr );

		if ( map_field_sexpr == (sexpr_t *)0 ) {
			control_syntax_error( len_msg, __FILE__, __LINE__, tuple_cnt );
		}

		ret = assign_list_pair( &new->field[ 1 ].direction, &new->field[ 1 ].field_name, SEXPR_CAR_LIST( map_field_sexpr ), tuple_cnt );
		if ( ret == -1 ) {
			RETURN_INT( ret );
		}

		assert( SEXPR_CDR_TYPE( map_field_sexpr ) == list_sexpr );

		if ( SEXPR_CDR_LIST( map_field_sexpr ) != (sexpr_t *)0 ) {
			control_syntax_error( len_msg, __FILE__, __LINE__, tuple_cnt );
		}

		if ( Debug ) {
			(void) fprintf( stderr, "direction: [%s], field name: [%s]\n", new->field[ 0 ].direction, new->field[ 1 ].field_name );
			(void) fprintf( stderr, "direction: [%s], field name: [%s]\n", new->field[ 1 ].direction, new->field[ 1 ].field_name );
		}

		assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

		sexpr = SEXPR_CDR_LIST( sexpr );
	}

	RETURN_INT( 0 );
}
