/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int assign_list_pair( char **first, char **second, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	str_msg[] = "expected a string";
	static const char	len_msg[] = "expected S-expression to have two values";

	assert( first != (char **)0 );
	assert( second != (char **)0 );

	DEBUG_FUNC_START;

	if ( sexpr == (sexpr_t *)0 ) {
		RETURN_INT( 0 );
	}

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		control_syntax_error( str_msg, __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	*first = SEXPR_CAR_STRING( sexpr );

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	sexpr = SEXPR_CDR_LIST( sexpr );

	if ( sexpr == (sexpr_t *)0 ) {
		control_syntax_error( len_msg, __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		control_syntax_error( str_msg, __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	*second = SEXPR_CAR_STRING( sexpr );

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( SEXPR_CDR_LIST( sexpr ) != (sexpr_t *)0 ) {
		control_syntax_error( len_msg, __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( Debug ) {
		(void) fprintf( stderr, "first: [%s], second [%s]\n", *first, *second );
	}

	RETURN_INT( 0 );
}
