/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int assign_input_dfile_attribute( input_ctl_t *input_ctl, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	char	*str;
	int	ret;

	assert( input_ctl != (input_ctl_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		control_syntax_error( "expected a string", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	str = SEXPR_CAR_STRING( sexpr );

	if ( Debug ) {
		fprintf( stderr, "str = [%s]\n", str );
	}

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( strcasecmp( str, "tags" ) == 0 ) {
		ret = assign_tag( &input_ctl->tag, &input_ctl->tag_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "map-fields" ) == 0 ) {
		ret = assign_map_fields( &input_ctl->map_field_tbl, &input_ctl->map_field_tbl_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "blocks-per-buffer" ) == 0 ) {
		ret = assign_ushort( &input_ctl->blocks_per_buffer_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "buffer-count" ) == 0 ) {
		ret = assign_ushort( &input_ctl->buffer_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "where" ) == 0 ) {
		input_ctl->record_filter = sexpr;
		RETURN_INT( 0 );
	}

	RETURN_INT( -1 );
}
