/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


int copy_exec_args( char ***result, char **arg, unsigned short arg_cnt )
{
	size_t	alloc_size;
	char	**new, *str;

	assert( result != (char ***)0 );
	assert( arg != (char **)0 );
	assert( arg_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	/*
	** Allocate one extra pointer for null termination.
	*/
	alloc_size = sizeof( char * ) * (size_t)( arg_cnt + 1 );
	new = (char **)malloc( alloc_size );
	if ( new == (char **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	*result = new;

	for ( ; arg_cnt > (unsigned short)0; --arg_cnt ) {
		str = strdup( *arg );
		if ( str == (char *)0 ) {
			UNIX_ERROR( "strdup() failed" );
			RETURN_INT( -1 );
		}

		*new = str;
		++new;
		++arg;
	}

	/*
	** Null terminate argument list.
	*/
	*new = (char *)0;

	RETURN_INT( 0 );
}
