/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This compare function is used to compare completed_t structures.
*/
int completed_cmp( const void *x, const void *y )
{
	int	ret;
	const completed_t	*lhs, *rhs;

	assert( x != (const void *)0 );
	assert( y != (const void *)0 );

	lhs = (const completed_t *)x;
	rhs = (const completed_t *)y;

	ret = strcmp( lhs->step_name, rhs->step_name );

	if ( ret != 0 ) {
		return ret;
	}

#if 0
fprintf( stderr, "lhs->partition %p, rhs->partition %p\n", lhs->partition, rhs->partition );
#endif
	if ( lhs->partition == (const char *)0 || rhs->partition == (const char *)0 ) {
		if ( lhs->partition > rhs->partition ) {
			return 1;
		} else {
			if ( rhs->partition > lhs->partition ) {
				return -1;
			} else {
				return 0;
			}
		}
	}

#if 0
fprintf( stderr, "lhs->partition [%s], rhs->partition [%s]\n", lhs->partition, rhs->partition );
#endif
	return strcmp( lhs->partition, rhs->partition );
}
