/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "where.h"
#include "dfile_agfunc.h"


/*
** This function is called at each controlled break for each aggregate
** function to pass results to output buffer.
*/

int eval_agfunc( func_t *agfunc, unsigned long rec_cnt )
{
	int	len;
	double	result;

	assert( agfunc != (func_t *)0 );

	DEBUG_FUNC_START;

	switch ( agfunc->func_type ) {
	case Average:
		if ( rec_cnt == 0UL ) {
			result = 0.0;
		} else {
			result = agfunc->value_u.num / (double)rec_cnt;
		}

		len = snprintf( agfunc->format_result, sizeof( agfunc->format_result ), agfunc->output_format, result );

		if ( len <= 0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "snprintf() failed to format average.\n", stderr );
			RETURN_INT( -1 );
		}

		*agfunc->result_bind->field_buffer = agfunc->format_result;
		*agfunc->result_bind->field_length = (size_t)len;
		break;

	case Sum:
		len = snprintf( agfunc->format_result, sizeof( agfunc->format_result ), agfunc->output_format, agfunc->value_u.num );

		if ( len <= 0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "snprintf() failed to format numeric value.\n", stderr );
			RETURN_INT( -1 );
		}

		*agfunc->result_bind->field_buffer = agfunc->format_result;
		*agfunc->result_bind->field_length = (size_t)len;
		break;

	case Num_min:
	case Num_max:
		*agfunc->result_bind->field_buffer = agfunc->format_result;
		*agfunc->result_bind->field_length = strlen( agfunc->format_result );
		break;

	case Str_min:
	case Str_max:
		*agfunc->result_bind->field_buffer = agfunc->value_u.str;
		*agfunc->result_bind->field_length = strlen( agfunc->value_u.str );
		break;

	case Count:
		len = snprintf( agfunc->format_result, sizeof( agfunc->format_result ), "%lu", rec_cnt );

		if ( len <= 0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "snprintf() failed to format numeric value.\n", stderr );
			RETURN_INT( -1 );
		}

		*agfunc->result_bind->field_buffer = agfunc->format_result;
		*agfunc->result_bind->field_length = (size_t)len;
		break;

	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Programming error--unknown func_type [", stderr );
		(void) fput_int( agfunc->func_type, stderr );
		(void) fputs( "] encountered.\n", stderr );
		abort();
	}

	RETURN_INT( 0 );
}
