/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_agfunc.h"


/*
** This function copies key fields between two bind structures.
*/
int copy_bind( dfile_bind_t **to_bind_tbl, const dfile_bind_t **from_bind_tbl, size_t *alloc_key_size, unsigned short key_tbl_cnt )
{
	char	*new_str;
	size_t	value_len, value_size;
	const dfile_bind_t	*from_bind;
	dfile_bind_t	*to_bind;

	assert( to_bind_tbl != (dfile_bind_t **)0 );
	assert( from_bind_tbl != (const dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		to_bind = *to_bind_tbl;
		from_bind = *from_bind_tbl;

		value_len = *from_bind->field_length;

		/*
		** Add one for null character.
		*/
		value_size = value_len + (size_t)1;

		if ( value_size > *alloc_key_size ) {
			if ( *alloc_key_size == (size_t)0 ) {
				new_str = (char *)malloc( value_size );
			} else {
				new_str = (char *)realloc( *to_bind->field_buffer, value_size );
			}

			if ( new_str == (char *)0 ) {
				UNIX_ERROR( "malloc()/realloc() failed" );
				RETURN_INT( -1 );
			}

			*to_bind->field_buffer = new_str;
			*alloc_key_size = value_size;
		}

		(void) memcpy( (void *)*to_bind->field_buffer, (void *)*from_bind->field_buffer, value_size );

		*to_bind->field_length = value_len;

		++to_bind_tbl;
		++from_bind_tbl;
		++alloc_key_size;
	}

	RETURN_INT( 0 );
}
