/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "where.h"
#include "_where.h"

static const char       rcsid[] = "$Id: _where_datum_syntax.c,v 1.2 2009/10/16 17:27:11 keith Exp $";

/*
** $Log: _where_datum_syntax.c,v $
** Revision 1.2  2009/10/16 17:27:11  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/18 05:31:37  keith
** Initial revision
**
*/

/*
** This function builds portion of syntax tree associated data elements.
*/

int _where_datum_syntax( datum_t *datum, char *value, dfile_t *dfile )
{
	static const char func[] = "_where_datum_syntax";
	char	*value_end, *field_name;
	double	number;
	dfile_bind_t	bind, **bind_entry;

	assert( datum != (datum_t *)0 );
	assert( value != (char *)0 );

	DEBUG_FUNC_START;

	DATUM_TYPE( datum ) = Unknown_datum;

	if ( *value == '$' ) {
		field_name = &value[ 1 ];
		strtoupper( field_name );
		bind.field_name = field_name;

		bind_entry = (dfile_bind_t **)dhfind( (void *)&bind, dfile->bind_hash_table, strhkey( bind.field_name ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Variable [", stderr );
			(void) fputs( bind.field_name, stderr );
			(void) fputs( "] was not defined.\n", stderr );
			RETURN_INT( WHERE_UNKNVAR );
		}

		DATUM_VAR_BIND( datum ) = *bind_entry;
		DATUM_TYPE( datum ) = Variable;

		if ( Debug ) {
			(void) fputs( "Variable name [", stderr );
			(void) fputs( DATUM_VAR_BIND( datum )->field_name, stderr );
			(void) fputs( "].\n", stderr );
			(void) fputs( "Variable buffer pointer [", stderr );
			(void) fprintf( stderr, "%p", DATUM_VAR_BIND( datum )->field_buffer );
			(void) fputs( "].\n", stderr );
		}

		RETURN_INT( WHERE_NOERR );
	}

	if ( *value == '-' || isdigit( *value ) ) {
		number = strtod( value, &value_end );
		assert( value_end >= value );
		if ( value_end != value && *value_end == (char)0 ) {
			DATUM_TYPE( datum ) = Constant;
			DATUM_CONST_TYPE( datum ) = Real;
			DATUM_CONST_REAL( datum ) = number;
			if ( Debug ) {
				(void) fputs( "Real value [", stderr );
				(void) fprintf( stderr, "%g", DATUM_CONST_REAL( datum ) );
				(void) fputs( "].\n", stderr );
			}
			RETURN_INT( WHERE_NOERR );
		}
	}

	DATUM_TYPE( datum ) = Constant;
	DATUM_CONST_TYPE( datum ) = Literal;

	if ( *value == '\'' ) {
		/*
		** Skip leading tick mark.
		*/
		++value;
	}

	DATUM_CONST_LITERAL( datum ) = value;

	if ( Debug ) {
		(void) fputs( "Literal value [", stderr );
		(void) fputs( DATUM_CONST_LITERAL( datum ), stderr );
		(void) fputs( "].\n", stderr );
	}

	RETURN_INT( WHERE_NOERR );
}
