/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"

static const char       rcsid[] = "$Id: _where_condition_syntax.c,v 1.2 2009/10/16 17:27:11 keith Exp $";

/*
** $Log: _where_condition_syntax.c,v $
** Revision 1.2  2009/10/16 17:27:11  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/18 05:30:19  keith
** Initial revision
**
*/

/*
** This function is used when building parse tree to handle operators.
*/

int _where_condition_syntax( condition_t *condition, sexpr_t *sexpr, dfile_t *dfile )
{
	static const char func[] = "_where_condition_syntax";
	int	ret;
	char	*function;
	sexpr_t	*func_sexpr;

	assert( condition != (condition_t *)0 );
	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	if ( sexpr == (sexpr_t *)0 || SEXPR_CAR_TYPE( sexpr ) != list_sexpr ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Missing a condition expression.\n", stderr );
		RETURN_INT( WHERE_SYNTAX );
	}

	func_sexpr = SEXPR_CAR_LIST( sexpr );

	if ( SEXPR_CAR_TYPE( func_sexpr ) != string_sexpr ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Missing condition function.\n", stderr );
		RETURN_INT( WHERE_SYNTAX );
	}

	function = SEXPR_CAR_STRING( func_sexpr );

	if ( Debug ) {
		fprintf( stderr, "function = [%s]\n", function );
	}

	if ( strcasecmp( function, "and" ) == 0 ) {
		COND_OP( condition ) = And;
	} else {
		if ( strcasecmp( function, "or" ) == 0 ) {
			COND_OP( condition ) = Or;
		} else {
			if ( strcasecmp( function, "not" ) == 0 ) {
				COND_OP( condition ) = Not;
			} else {
				ret = _where_compare_syntax( condition, function, SEXPR_CDR_LIST( func_sexpr ), dfile );
				RETURN_INT( ret );
			}
		}
	}

	ret = _where_multi_cond_syntax( COND_MULTI_COND( condition ), SEXPR_CDR_LIST( func_sexpr ), dfile );

	if ( ret != WHERE_NOERR ) {
		RETURN_INT( ret );
	}

	if ( COND_OP( condition ) == And || COND_OP( condition ) == Or ) {
		if ( COND_MULTI_COND_CNT( condition ) < 2UL ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( ( COND_OP( condition ) == And ) ? "AND" : "OR", stderr );
			(void) fputs( " needs at least two conditions.\n", stderr );
			RETURN_INT( WHERE_SYNTAX );
		}
	} else {
		if ( COND_OP( condition ) == Not ) {
			if ( COND_MULTI_COND_CNT( condition ) != 1UL ) {
				FPUT_SRC_CODE( stderr );
				(void) fputs( "not must have one condition.\n", stderr );
				RETURN_INT( WHERE_SYNTAX );
			}
		}
	}

	RETURN_INT( WHERE_NOERR );
}
