/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <ctype.h>
#include <assert.h>
#include "tbox.h"

static const char       rcsid[] = "$Id: strtoupper.c,v 1.2 2009/10/16 18:00:43 keith Exp $";

/*
** $Log: strtoupper.c,v $
** Revision 1.2  2009/10/16 18:00:43  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 03:01:10  keith
** Initial revision
**
*/

/*
** This function converts a string to upper case.
*/

void strtoupper( register char *str )
{
	static const char func[] = "strtoupper";

	assert( str != (char *)0 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s( %s )\n", func, str );
	}

	DEBUG_FUNC_START;

	while ( *str != (char)0 ) {
		*str = toupper( *str );
		++str;
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result: [%s]\n", str );
	}

	RETURN_VOID;
}
