/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"

static const char       rcsid[] = "$Id: sexpr_format.c,v 1.2 2009/10/16 17:11:40 keith Exp $";

/*
** $Log: sexpr_format.c,v $
** Revision 1.2  2009/10/16 17:11:40  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 09:14:05  keith
** Initial revision
**
*/

/*
** This function formats sexpr_t structure to an ASCII string.
** Return value is zero for okay, -1 for UNIX error and positive value
** to represent particular s-expression failure.
*/

int sexpr_format( char *str, size_t str_size, const sexpr_t *sexpr )
{
	static const char func[] = "sexpr_format";
	const unsigned long	initial_depth = 0;
	int	ret;
	size_t	str_len, str_avail;
	char	*orig_str;
	sexpr_t	implied_sexpr;

	assert( str != (char *)0 );

	DEBUG_FUNC_START;

	if ( str_size == 0 ) {
		if ( Debug ) {
			(void) fputs( "Resulting string has maximum length zero.\n", stderr );
		}
		RETURN_INT( SEXPR_NOSPACE );
	}

	orig_str = str;
	str_len = str_size - (size_t)1;
	str_avail = str_len;

	implied_sexpr.car.type = list_sexpr;
	implied_sexpr.car.value_u.list = (sexpr_t *)sexpr;
	implied_sexpr.cdr.type = list_sexpr;
	implied_sexpr.cdr.value_u.list = (sexpr_t *)0;

	ret = _sexpr_format_list( &str, &str_avail, &implied_sexpr, initial_depth );

	assert( str_len >= str_avail );

	*str = (char)0;

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", orig_str );
	}

	RETURN_INT( ret );
}
