/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"

static const char       rcsid[] = "$Id: sexpr_error.c,v 1.2 2009/10/16 17:11:40 keith Exp $";

/*
** $Log: sexpr_error.c,v $
** Revision 1.2  2009/10/16 17:11:40  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 09:12:48  keith
** Initial revision
**
*/

/*
** This function formats an error message.
*/

const char *sexpr_error( int sexpr_errno )
{
	static const char func[] = "sexpr_error";
	static const char	unknown_msg[] = "unknown error";
	const char	*ret;

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "error code %d\n", sexpr_errno );
	}

	if ( sexpr_errno < 0 ) {
		/*
		** UNIX error
		*/
		ret = strerror( errno );
	} else {
		/*
		** sexpr error
		*/
		if ( sexpr_errno >= Sexpr_err_msg_cnt ) {
			ret = unknown_msg;
		} else {
			ret = Sexpr_err_msg[ sexpr_errno ];
		}
	}

	RETURN_POINTER( ret );
}
