/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"

static const char       rcsid[] = "$Id: _sexpr_find_end_of_string.c,v 1.2 2009/10/16 17:11:40 keith Exp $";

/*
** $Log: _sexpr_find_end_of_string.c,v $
** Revision 1.2  2009/10/16 17:11:40  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 08:59:38  keith
** Initial revision
**
*/

int _sexpr_find_end_of_string( const char **string_end, const char *str, const char *delim )
{
	static const char func[] = "_sexpr_find_end_of_string";
	const char	escape_char = '\\';
	const char	*ptr, *prev_escaped, *prev_char;

	assert( string_end != (const char **)0 );
	assert( str != (const char *)0 );
	assert( delim != (const char *)0 );

	DEBUG_FUNC_START;

	prev_escaped = str - 1;
	*string_end = (const char *)0;

	for ( ;; ) {
		ptr = (const char *)strpbrk( str, delim );

		if ( ptr == (const char *)0 ) {
			if ( Debug ) {
				(void) fputs( "Did not find termination character [", stderr );
				(void) fputs( delim, stderr );
				(void) fputs( "].\n", stderr );

			}
			RETURN_INT( SEXPR_NOTERM );
		}

		prev_char = ptr - 1;
		if ( prev_char > prev_escaped && *prev_char == escape_char ) {
			/*
			** Escape delimiter.
			*/
			prev_escaped = ptr;
			str = ptr + 1;
		} else {
			break;
		}
	}

	*string_end = ptr;

	RETURN_INT( 0 );
}
