/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"

static const char       rcsid[] = "$Id: _sexpr_create_string_value.c,v 1.2 2009/10/16 17:11:40 keith Exp $";

/*
** $Log: _sexpr_create_string_value.c,v $
** Revision 1.2  2009/10/16 17:11:40  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 08:57:56  keith
** Initial revision
**
*/

int _sexpr_create_string_value( sexpr_value_t *sexpr_value, const char *beg, const char *end )
{
	static const char func[] = "_sexpr_create_string_value";
	const char	escape_char = '\\';
	register const char	*src;
	register char	*dest;
	char	*new;
	size_t	len, alloc_size;

	assert( sexpr_value != (sexpr_value_t *)0 );
	assert( beg != (const char *)0 );
	assert( end != (const char *)0 );
	assert( end >= beg );

	DEBUG_FUNC_START;

	len = (size_t)( end - beg );
	alloc_size = len + (size_t)1;

	if ( Debug ) {
		(void) fputs( "copying string [", stderr );
		(void) fwrite( beg, len, (size_t)1, stderr );
		(void) fputs( "]\n", stderr );
	}

	new = (char *)malloc( alloc_size );
	if ( new == (char *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	src = beg;
	dest = new;
	while ( end > src ) {
		if ( *src == escape_char ) {
			/*
			** Discard escape character.
			*/
			++src;

			if ( src == end ) {
				break;
			}

			switch ( *src ) {
			case 'n':
				*dest = '\n';
				break;
			case 't':
				*dest = '\t';
				break;
			default:
				*dest = *src;
			}
		} else {
			*dest = *src;
		}

		++src;
		++dest;
	}

	*dest = (char)0;

	sexpr_value->type = string_sexpr;
	sexpr_value->value_u.string = new;

	RETURN_INT( 0 );
}
