/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"

static const char       rcsid[] = "$Id: alloc_record_key.c,v 1.2 2009/10/16 17:02:35 keith Exp $";

/*
** $Log: alloc_record_key.c,v $
** Revision 1.2  2009/10/16 17:02:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/01 05:17:59  keith
** Initial revision
**
*/

/*
** This function allocates an address pointers for record key.
*/
int alloc_record_key( field_t ***rec_key, size_t key_cnt )
{
	static const char	func[] = "alloc_record_key";
	size_t	alloc_size;
	field_t	**new;

	assert( rec_key != (field_t ***)0 );
	assert( key_cnt > (size_t)0 );

	DEBUG_FUNC_START;

	alloc_size = sizeof( field_t * ) * (size_t)key_cnt;

	new = (field_t **)malloc( alloc_size );
	if ( new == (field_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		*rec_key = (field_t **)0;
		RETURN_INT( -1 );
	}

	*rec_key = new;

	RETURN_INT( 0 );
}
