/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"

static const char       rcsid[] = "$Id: alloc_record.c,v 1.2 2009/10/16 17:02:35 keith Exp $";

/*
** $Log: alloc_record.c,v $
** Revision 1.2  2009/10/16 17:02:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/01 05:14:01  keith
** Initial revision
**
*/

/*
** This function allocates an address pointer per record.
*/
int alloc_record( field_t ***rec, size_t **rec_size, unsigned long rec_cnt )
{
	static const char	func[] = "alloc_record";
	size_t	alloc_size, *new_size;
	field_t	**new_field;

	assert( rec != (field_t ***)0 );

	DEBUG_FUNC_START;

	alloc_size = sizeof( field_t * ) * ( (size_t)rec_cnt + (size_t)1 );

	new_field = (field_t **)realloc( (void *)*rec, alloc_size );
	if ( new_field == (field_t **)0 ) {
		UNIX_ERROR( "realloc() failed" );
		RETURN_INT( -1 );
	}

	new_field[ rec_cnt ] = (field_t *)0;

	*rec = new_field;

	if ( rec_size == (size_t **)0 ) {
		/*
		** Do not allocate size array.
		*/
		RETURN_INT( 0 );
	}

	alloc_size = sizeof( size_t ) * ( (size_t)rec_cnt + (size_t)1 );

	new_size = (size_t *)realloc( (void *)*rec_size, alloc_size );
	if ( new_size == (size_t *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		RETURN_INT( -1 );
	}

	new_size[ rec_cnt ] = (size_t)0;

	*rec_size = new_size;

	RETURN_INT( 0 );
}
