/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"

static const char       rcsid[] = "$Id: assign_field_bind.c,v 1.2 2009/10/16 16:53:52 keith Exp $";

/*
** $Log: assign_field_bind.c,v $
** Revision 1.2  2009/10/16 16:53:52  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/28 23:56:44  keith
** Initial revision
**
*/

/*
** This function assigns field binds within the record layout.
*/
int assign_field_bind( dfile_bind_t ***ret_key_bind_tbl, const char **key_tbl, unsigned short key_tbl_cnt, void *bind_hash_tbl )
{
	static const char	func[] = "assign_field_bind";
	unsigned short ndx;
	size_t	alloc_size;
	dfile_bind_t	bind, **bind_entry, **key_bind_tbl;

	assert( ret_key_bind_tbl != (dfile_bind_t ***)0 );
	assert( key_tbl != (const char **)0 );
	assert( bind_hash_tbl != (void *)0 );

	DEBUG_FUNC_START;

	*ret_key_bind_tbl = (dfile_bind_t **)0;

	alloc_size = sizeof( dfile_bind_t * ) * (size_t)key_tbl_cnt;
	key_bind_tbl = (dfile_bind_t **)malloc( alloc_size );
	if ( key_bind_tbl == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	for ( ndx = (unsigned short)0; ndx < key_tbl_cnt; ++ndx ) {
		bind.field_name = key_tbl[ ndx ];

		bind_entry = (dfile_bind_t **)dhfind( (void *)&bind, bind_hash_tbl, strhkey( bind.field_name ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Key field [", stderr );
			(void) fputs( key_tbl[ ndx ], stderr );
			(void) fputs( "] was not defined as a DFile field.\n", stderr );
			RETURN_INT( -1 );
		}

		key_bind_tbl[ ndx ] = *bind_entry;
	}

	*ret_key_bind_tbl = key_bind_tbl;

	RETURN_INT( 0 );
}
