/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: dfile_bind_field_name_cmp.c,v 1.2 2009/10/16 07:35:52 keith Exp $";

/*
** $Log: dfile_bind_field_name_cmp.c,v $
** Revision 1.2  2009/10/16 07:35:52  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 18:41:28  keith
** Initial revision
**
*/

/*
** This function is used to compare dfile_bind_t structures by field_name.
*/

int dfile_bind_field_name_cmp( const void *x, const void *y )
{
	assert( x != (const void *)0 );
	assert( y != (const void *)0 );
	assert( ( (const dfile_bind_t *)x )->field_name != (const char *)0 );
	assert( ( (const dfile_bind_t *)y )->field_name != (const char *)0 );

	return strcmp( ( (const dfile_bind_t *)x )->field_name, ( (const dfile_bind_t *)y )->field_name );
}
