/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_var_field_failure.c,v 1.2 2009/10/16 07:35:56 keith Exp $";

/*
** $Log: _dfile_var_field_failure.c,v $
** Revision 1.2  2009/10/16 07:35:56  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 04:45:18  keith
** Initial revision
**
*/

/*
** This function is called when attempting to write a field value too large
** for the var field format.
*/

int _dfile_var_field_failure( dfile_t *dfile, unsigned short parse_field_ndx )
{
	static const char	func[] = "_dfile_var_field_failure";
	dfile_bind_t	*bind;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	bind = &dfile->bind[ parse_field_ndx ];

	fput_src_code( __FILE__, __LINE__, stderr );
	(void) fputs( "Field [", stderr );
	(void) fputs( bind->field_name, stderr );
	(void) fputs( "] value [", stderr );
	(void) fwrite( *bind->field_buffer, sizeof( char ), *bind->field_length, stderr );
	(void) fputs( "] exceeds maximum length ", stderr );
	(void) fput_int( UCHAR_MAX, stderr );
	(void) fputs( ".\n", stderr );

	RETURN_INT( -1 );
}
