/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <ctype.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_skip_spaces.c,v 1.2 2009/10/16 07:35:56 keith Exp $";

/*
** $Log: _dfile_skip_spaces.c,v $
** Revision 1.2  2009/10/16 07:35:56  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 04:12:59  keith
** Initial revision
**
*/

/*
** This function is used to parse registry records. It skips over white spaces
** between fields.
*/

int _dfile_skip_spaces( char **rec )
{
	static const char	func[] = "_dfile_skip_spaces";

	assert( rec != (char **)0 );
	assert( *rec != (char *)0 );

	DEBUG_FUNC_START;

	/*
	** Skip spaces.
	*/
	while ( **rec != (char)0 ) {
		if ( **rec == '#' ) {
			/*
			** Remaining portion of line is comment.
			*/
			RETURN_INT( -1 );
		}

		if ( !isspace( **rec ) ) {
			break;
		}
		++*rec;
	}

	if ( **rec == (char)0 ) {
		/*
		** End of line reached.
		*/
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
