/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_process_delimited_record.c,v 1.2 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_process_delimited_record.c,v $
** Revision 1.2  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/26 08:50:36  keith
** Initial revision
**
*/

/*
** This function copies values from bind variables to buffer in
** delimited record format.
*/
int _dfile_process_delimited_record( dfile_t *dfile, dfile_buffer_t *buffer )
{
	static const char	func[] = "_dfile_process_delimited_record";
	unsigned short	field_ndx, max_field_separator;
	dfile_bind_t	*bind;

	assert( dfile != (dfile_t *)0 );
	assert( buffer != (dfile_buffer_t *)0 );

	DEBUG_FUNC_START;

	bind = dfile->bind;
	max_field_separator = dfile->bind_cnt - (unsigned short)1;

	assert( bind != (dfile_bind_t *)0 );

	assert( dfile->format_str_func != (int (*)( char **, const char *, const char **, dfile_rec_t ))0 );
	assert( dfile->format_func != (int (*)( char **, const char *, const char **, size_t *, dfile_rec_t ))0 );

	for ( field_ndx = (unsigned short)0; field_ndx < dfile->bind_cnt; ++field_ndx ) {
		if ( _dfile_copy_field_to_buffer( dfile, *bind->field_buffer, bind->field_length ) == -1 ) {
			RETURN_INT( -1 );
		}
		++bind;
		buffer = dfile->application_buffer;

		if ( buffer->buf_ptr >= buffer->buf_ptr_end ) {
			if ( _dfile_advance_buffer( dfile, buffer ) == -1 ) {
				RETURN_INT( -1 );
			}
			buffer = dfile->application_buffer;
		}
		if ( field_ndx < max_field_separator ) {
			*buffer->buf_ptr = dfile->rec_attribute.field_separator;
			++buffer->buf_ptr;
		}
	}

	*buffer->buf_ptr = dfile->rec_attribute.record_separator;
	++buffer->buf_ptr;

	RETURN_INT( 0 );
}
