/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <ctype.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_parse_registry_field.c,v 1.2 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_parse_registry_field.c,v $
** Revision 1.2  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/26 07:29:32  keith
** Initial revision
**
*/

/*
** This function parses field name from record layout line of text. End of
** field name is expected to be one or more white space characters.
*/

int _dfile_parse_registry_field( char **rec )
{
	static const char	func[] = "_dfile_parse_registry_field";
	register char	*ptr;

	assert( rec != (char **)0 );
	assert( *rec != (char *)0 );

	DEBUG_FUNC_START;

	ptr = *rec;

	while ( *ptr != (char)0 ) {
		if ( isspace( *ptr ) ) {
			break;
		}
		*ptr = toupper( *ptr );
		++ptr;
	}

	if ( *ptr == (char)0 ) {
		/*
		** End of line reached.
		*/
		RETURN_INT( -1 );
	}

	/*
	** Null terminate field by overwriting white space character.
	*/
	*ptr = (char )0;
	*rec = &ptr[ 1 ];

	RETURN_INT( 0 );
}
