/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_identify_format.c,v 1.2 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_identify_format.c,v $
** Revision 1.2  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/25 07:50:23  keith
** Initial revision
**
*/

/*
** This function determines whether a file is ASCII or GZIP compressed.
*/

dfile_format_t _dfile_identify_format( const char *fname )
{
	static const char	func[] = "_dfile_identify_format";
	static const char	end_msg[] = "End %s() returning %s at %s\n";
	size_t	len;
	static const char	gzip_suffix[] = ".gz";
	const size_t	gzip_suffix_len = sizeof( gzip_suffix ) - 1;

	assert( fname != (const char *)0 );

	DEBUG_FUNC_START;

	len = strlen( fname );
	if ( len > gzip_suffix_len ) {
		if ( strcmp( &fname[ len - gzip_suffix_len ], gzip_suffix ) == 0 ) {
			if ( Debug ) {
				(void) fprintf( stderr, end_msg, func, "Dfile_zipped", get_ctime() );
			}
			return Dfile_zipped;
		}
	}

	if ( Debug ) {
		(void) fprintf( stderr, end_msg, func, "Dfile_ascii", get_ctime() );
	}

	return Dfile_ascii;
}
