/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_get_record.c,v 1.2 2009/10/16 07:35:54 keith Exp $";

/*
** $Log: _dfile_get_record.c,v $
** Revision 1.2  2009/10/16 07:35:54  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/22 22:51:33  keith
** Initial revision
**
*/

/*
** This function loops until a record with the correct number of fields
** can be parsed.
*/

dfile_parse_t _dfile_get_record( dfile_t *dfile )
{
	static const char	func[] = "_dfile_get_record";
	dfile_parse_t	parse;
	dfile_buffer_t	*buffer;

	DEBUG_FUNC_START;

	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );
	assert( buffer->state != (dfile_state_t *)0 );

	do {
		++dfile->file_rec_cnt;
		++buffer->buffer_rec_cnt;

		if ( Debug ) {
			(void) fprintf( stderr, "parsing record %lu buffer, %lu file, from buffer %hu.\n", buffer->buffer_rec_cnt, dfile->file_rec_cnt, buffer->buffer_id );
		}

		parse = _dfile_parse_record( dfile );

	} while ( parse == Dfile_parse_failed && buffer->buf_ptr > buffer->buf_ptr_end );

	RETURN_INT( parse );
}
