/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

/*
** $Id: sexpr.h,v 1.2 2009/10/16 17:13:06 keith Exp $
**
** $Log: sexpr.h,v $
** Revision 1.2  2009/10/16 17:13:06  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 09:16:32  keith
** Initial revision
**
*/

#define	SEXPR_UNIXERR	-1
#define	SEXPR_NOERR	0
#define SEXPR_EOEXPR	1
#define SEXPR_RPAREN	2
#define SEXPR_NOTERM	3
#define SEXPR_NOSPACE	4
#define SEXPR_UNKNVAL	5

typedef struct sexpr_s	sexpr_t;

typedef enum { unknown_sexpr = 0, list_sexpr, string_sexpr } sexpr_type_t;

typedef struct {
	sexpr_type_t	type;
	union {
		char	*string;
		sexpr_t	*list;
	} value_u;
} sexpr_value_t;

struct sexpr_s {
	sexpr_value_t	car;
	sexpr_value_t	cdr;
};

#define SEXPR_CAR_TYPE( x )	( x )->car.type
#define SEXPR_CAR_LIST( x )	( x )->car.value_u.list
#define SEXPR_CAR_STRING( x )	( x )->car.value_u.string

#define SEXPR_CDR_TYPE( x )	( x )->cdr.type
#define SEXPR_CDR_LIST( x )	( x )->cdr.value_u.list
#define SEXPR_CDR_STRING( x )	( x )->cdr.value_u.string

extern const char *Sexpr_err_msg[];
extern const size_t Sexpr_err_msg_cnt;

int sexpr_parse( sexpr_t **, const char * );
int _sexpr_parse_pair( sexpr_t **, int *, const char **, unsigned long );
int _sexpr_find_end_of_string( const char **, const char *, const char * );
int _sexpr_create_string_value( sexpr_value_t *, const char *, const char * );
int _sexpr_assign_car( sexpr_value_t *, int *, const char **, unsigned long );
int sexpr_format( char *, size_t, const sexpr_t * );
int _sexpr_format_list( char **, size_t *, const sexpr_t *, unsigned long );
int _sexpr_format_string( char **, size_t *, const char * );
int sexpr_load( sexpr_t **, const char * );
const char *sexpr_error( int sexpr_errno );
