/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"

static const char       rcsid[] = "$Id: compare_field_bind.c,v 1.2 2009/10/16 20:26:12 keith Exp $";

/*
** $Log: compare_field_bind.c,v $
** Revision 1.2  2009/10/16 20:26:12  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/12 16:52:02  keith
** Initial revision
**
*/

/*
** This function compares key fields between field and bind structures.
*/
int compare_field_bind( const field_t **field, const dfile_bind_t **bind_key, unsigned short key_tbl_cnt )
{
	static const char	func[] = "compare_field_bind";
	int	result;
	const field_t	*field_ptr;
	const dfile_bind_t	*bind;

	assert( field != (const field_t **)0 );
	assert( bind_key != (const dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		bind = *bind_key;
		field_ptr = *field;

		result = strnncmp( field_ptr->value, field_ptr->length, *bind->field_buffer, *bind->field_length );

		if ( result != 0 ) {
			RETURN_INT( result );
		}

		++bind_key;
	}

	RETURN_INT( 0 );
}
