/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "where.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: merge_records.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: merge_records.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/12 08:30:35  keith
** Initial revision
**
*/

static int sort_write( dfile_t *, field_t * );

/*
** This function merges sorted records.
*/
int merge_records( dfile_t *dfile, field_t **record, unsigned long record_cnt, const order_by_t *key_tbl, const unsigned short *key_ndx_tbl, unsigned short key_tbl_cnt, merge_queue_t *merge_queue )
{
	static const char	func[] = "merge_records";
	unsigned long	record_ndx;
	int	cmp;

	assert( dfile != (dfile_t *)0 );
	assert( key_tbl != (const order_by_t *)0 );
	assert( key_ndx_tbl != (const unsigned short *)0 );
	assert( merge_queue != (merge_queue_t *)0 );

	DEBUG_FUNC_START;

	record_ndx = 0UL;

	while ( record_ndx < record_cnt || merge_queue != (merge_queue_t *)0 ) {
		if ( record_ndx < record_cnt && merge_queue != (merge_queue_t *)0 ) {
			/*
			** Have both sorted and merge records.
			*/
			cmp = compare_sort_field_bind( *record, key_tbl, key_ndx_tbl, merge_queue->dfile->bind, merge_queue->key_ndx_tbl, key_tbl_cnt );

			if ( cmp > 0 ) {
				if ( merge_write( dfile, &merge_queue, key_tbl, key_tbl_cnt ) == -1 ) {
					RETURN_INT( -1 );
				}
			} else {
				if ( sort_write( dfile, *record ) == -1 ) {
					RETURN_INT( -1 );
				}
				++record;
				++record_ndx;
			}
		} else {
			if ( record_ndx < record_cnt ) {
				assert( merge_queue == (merge_queue_t *)0 );
				if ( sort_write( dfile, *record ) == -1 ) {
					RETURN_INT( -1 );
				}
				++record;
				++record_ndx;
			} else {
				assert( record_ndx >= record_cnt );
				assert( merge_queue != (merge_queue_t *)0 );
				if ( merge_write( dfile, &merge_queue, key_tbl, key_tbl_cnt ) == -1 ) {
					RETURN_INT( -1 );
				}
			}
		}
	}

	RETURN_INT( 0 );
}

static int sort_write( dfile_t *dfile, field_t *field )
{
	copy_record_to_bind( dfile->bind, dfile->bind_cnt, field );
	return dfile_write( dfile );
}
