/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: main.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: main.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/10 15:06:11  keith
** Initial revision
**
*/

/*
** This program sorts records from dfiles into one output dfile.
*/
int main( int argc, char **argv )
{
	static const char	func[] = "main";
	const char	*input_dfile_name, *output_dfile_name;
	const char	*key_argument, *merge_dfile_name;
	const char	*control_file;
	dfile_t	*output_dfile, **merge_dfile_tbl;
	int	ret, thread_input_flag, thread_output_flag;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt, **merge_io_field_map;
	order_by_t	*key_tbl;
	unsigned short	key_tbl_cnt, order_by_cnt, sort_cnt, merge_cnt;
	unsigned short	*key_ndx_tbl, **merge_key_ndx_tbl;
	unsigned long	record_cnt;
	field_t	**record;
	char	sort_algorithm;
	merge_queue_t	*merge_queue;
	order_by_t	*order_by;
	sm_dfile_t	*sort, *merge;
	output_t	output;

	if ( get_args( argc, argv, &input_dfile_name, &output_dfile_name, &thread_input_flag, &thread_output_flag, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &key_argument, &sort_algorithm, &merge_dfile_name, &control_file ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	ret = assign_control_information( &order_by, &order_by_cnt, &sort, &sort_cnt, &sort_algorithm, &merge, &merge_cnt, &output, control_file );
	if ( ret != 0 ) {
		RETURN_INT( 10 );
	}

	if ( order_by_cnt == (unsigned short)0 ) {
		/*
		** Use command line.
		*/
		assert( order_by == (order_by_t *)0 );
		if ( parse_key_argument( &key_tbl, &key_tbl_cnt, key_argument ) == -1 ) {
			RETURN_INT( 15 );
		}
	} else {
		/*
		** Use control file.
		*/
		assert( order_by != (order_by_t *)0 );
		key_tbl = order_by;
		key_tbl_cnt = order_by_cnt;
	}

	if ( open_output( &output_dfile, output_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_output_flag, &output ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( assign_order_by_field_offset( &key_ndx_tbl, key_tbl, key_tbl_cnt, output_dfile->bind, output_dfile->bind_hash_table ) == -1 ) {
		RETURN_INT( 25 );
	}

	if ( load_sort( &record, &record_cnt, input_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_input_flag, sort, sort_cnt, output_dfile->bind, output_dfile->bind_cnt, key_ndx_tbl, key_tbl_cnt ) == -1 ) {
		RETURN_INT( 30 );
	}

	if ( sort_records( record, record_cnt, key_tbl, key_ndx_tbl, key_tbl_cnt, sort_algorithm ) == -1 ) {
		RETURN_INT( 35 );
	}

	if ( merge_cnt > (unsigned short)0 || merge_dfile_name != (const char *)0 ) {
		if ( open_merge_input( &merge_dfile_tbl, merge_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_input_flag, &merge, &merge_cnt ) == -1 ) {
			RETURN_INT( 40 );
		}

		if ( map_merge_fields( &merge_io_field_map, &merge_key_ndx_tbl, merge_dfile_tbl, merge_cnt, output_dfile->bind, output_dfile->bind_cnt, key_tbl, key_tbl_cnt ) == -1 ) {
			RETURN_INT( 45 );
		}

		if ( create_merge_queue( &merge_queue, merge_dfile_tbl, merge_cnt, merge_io_field_map, key_tbl, merge_key_ndx_tbl, key_tbl_cnt, merge ) == -1 ) {
			RETURN_INT( 50 );
		}
	} else {
		merge_queue = (merge_queue_t *)0;
	}

	if ( merge_queue == (merge_queue_t *)0 ) {
		/*
		** Nothing to merge.
		*/
		if ( write_sorted_records( output_dfile, record, record_cnt ) == -1 ) {
			RETURN_INT( 55 );
		}
	} else {
		if ( merge_records( output_dfile, record, record_cnt, key_tbl, key_ndx_tbl, key_tbl_cnt, merge_queue ) == -1 ) {
			RETURN_INT( 60 );
		}
	}

	if ( dfile_write_close( output_dfile ) == -1 ) {
		RETURN_INT( 65 );
	}

#ifdef DEBUG
	debug_audit_heap();
#endif

	RETURN_INT( 0 );
}
