/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: control_syntax_error.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: control_syntax_error.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/10 06:16:29  keith
** Initial revision
**
*/

/*
** This function outputs syntax error messages for control structure.
*/
void control_syntax_error( const char *msg, const char *file, int line, unsigned short tuple )
{
	static const char	func[] = "control_syntax_error";

	assert( msg != (const char *)0 );
	assert( file != (const char *)0 );

	DEBUG_FUNC_START;

	fput_src_code( file, line, stderr );
	(void) fputs( "syntax error in tuple ", stderr );
	(void) fput_ushort( tuple, stderr );
	(void) fputs( ": ", stderr );
	(void) fputs( msg, stderr );
	(void) fputc( '\n', stderr );

	RETURN_VOID;
}
