/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: compare.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: compare.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/10 00:50:09  keith
** Initial revision
**
*/

/*
** This function compares two values.
*/
int compare( const char *lhs_str, size_t lhs_len, const char *rhs_str, size_t rhs_len, char value_type, char ascend_descend )
{
	static const char	func[] = "compare";
	int	result;

	assert( lhs_str != (const char *)0 );
	assert( rhs_str != (const char *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "[%s], %u, [%s], %u\n", lhs_str, lhs_len, rhs_str, rhs_len );
	}

	switch ( value_type ) {
	case 'A':
		result = strnncmp( lhs_str, lhs_len, rhs_str, rhs_len );
		break;
	case 'H':
		result = high_value_null_cmp( lhs_str, lhs_len, rhs_str, rhs_len );
		break;
	case 'N':
		result = numeric_cmp( lhs_str, rhs_str );
		break;
	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Programming error: ASCII/Numeric/High value null value type was [", stderr );
		(void) fputc( value_type, stderr );
		(void) fputs( "].\n", stderr );
		abort();
	}

	switch ( ascend_descend ) {
	case 'A':
		break;
	case 'D':
		result = -result;
		break;
	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Programming error: Ascend/Descend value was [", stderr );
		(void) fputc( ascend_descend, stderr );
		(void) fputs( "].\n", stderr );
		abort();
	}

	RETURN_INT( result );
}
